#include "math.h"
#include <fstream>
#include "fx.h"
#include "RefValues.h"
#include <iostream>

FXDEFMAP(RefValues) RefValuesMap[]=
{
  FXMAPFUNC(SEL_COMMAND,  RefValues::ID_COMPUTE,      RefValues::onCmdCompute),
  FXMAPFUNC(SEL_COMMAND,  RefValues::ID_OUTPUTTOFILE, RefValues::onCmdOutputToFile),
};

FXIMPLEMENT(RefValues,FXMainWindow,RefValuesMap,ARRAYNUMBER(RefValuesMap))

RefValues::RefValues(FXApp * a)
:FXMainWindow(a,"Reference Values for CFD codes (BLWF)",NULL,NULL,DECOR_ALL,0/*Start X*/,0/* Start Y*/,500/*Width*/,570/*Height*/)
{
  // Tooltip
  new FXToolTip(getApp());
	M_Ref=(double)0.8;
	T_0=(double)300.;
    T_Ref = (double)293.;
	Re_Ref=(double)5000000.;
	L_Ref=(double)1.;
	AL_Ref=(double)0.;
	S_Ref=(double)1.;

	T_opt=1;
	N=10;
	K=1.2;
	X_Ref=1.;
	Yplus=1.;
	MRefin=10;
	SCell=5.;


  // Connect DOUBLE target
  double_Mref.connect(M_Ref);
  double_Tref.connect(T_Ref);
  double_Lref.connect(L_Ref);
  double_Sref.connect(S_Ref);
  double_ALref.connect(AL_Ref);
  double_Reref.connect(Re_Ref);
  double_T0.connect(T_0);
  option_T.connect(T_opt);

  double_U8.connect(U_Ref);
  double_Ux.connect(Ux);
  double_Uyz.connect(Uyz);
  double_Mu.connect(Mu_Ref);
  double_Nu.connect(Nu_Ref);
  double_Rho.connect(Rho_Ref);
  double_P.connect(P_Ref);
  double_RUU.connect(RUU);
  double_SRUU.connect(SRUU);
  double_XLift.connect(XLift);
  double_YZLift.connect(YZLift);
  double_XDrag.connect(XDrag);
  double_YZDrag.connect(YZDrag);

  double_K.connect(K);
  double_Y.connect(Y);
  double_Y1.connect(Y1);
  double_Xref.connect(X_Ref);
  double_Yplus.connect(Yplus);
  int_N.connect(N);

  int_MRefin.connect(MRefin);
  double_SCell.connect(SCell);

  double_Dstar.connect(Dstar);
  double_Delta.connect(Delta);
  double_Cfturb.connect(Cfturb);

  this->ComputeRef();

  // Make some icons
  // Application icons
  //setIcon(icon);
  // Main window interior
  // Main window interior
  content=new FXVerticalFrame(this,LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y, 0,0,0,0, 0,0,0,0);

  group1=new FXHorizontalFrame(content,LAYOUT_FILL_X|LAYOUT_FILL_Y, 0,0,0,0, 0,0,0,0);
  group11=new FXVerticalFrame(group1,LAYOUT_FILL_X|LAYOUT_FILL_Y, 0,0,0,0, 0,0,0,0);
  group111=new FXVerticalFrame(group11,FRAME_SUNKEN|LAYOUT_TOP|LAYOUT_LEFT|LAYOUT_FILL_X|LAYOUT_FILL_Y, 0,0,0,0, 0,0,0,0);
    new FXLabel(group111,"INPUT VALUES",NULL,JUSTIFY_CENTER_X|LAYOUT_FILL_X);
    new FXHorizontalSeparator(group111,SEPARATOR_GROOVE|LAYOUT_FILL_X);
  matrix1112=new FXMatrix(group111,4,MATRIX_BY_COLUMNS|LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y);

	new FXFrame(matrix1112,LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
	new FXLabel(matrix1112,"Mach number",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
	new FXTextField(matrix1112,10,&double_Mref,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
	new FXFrame(matrix1112,LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);

//	optionT=new FXMenuPane(matrix1112);

//	new FXRadioButton(matrix1112,"",&option_T,FXDataTarget::ID_OPTION+0,LAYOUT_CENTER_Y|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|ICON_BEFORE_TEXT);
	new FXRadioButton(matrix1112,"",&option_T,FXDataTarget::ID_OPTION+0,LAYOUT_CENTER_Y);
	new FXLabel(matrix1112,"To",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
	new FXTextField(matrix1112,10,&double_T0,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
	new FXLabel(matrix1112,"grad K",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);


//	new FXRadioButton(matrix1112,"",&option_T,FXDataTarget::ID_OPTION+1,LAYOUT_CENTER_Y|LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW|ICON_BEFORE_TEXT);
	new FXRadioButton(matrix1112,"",&option_T,FXDataTarget::ID_OPTION+1,LAYOUT_CENTER_Y);
	new FXLabel(matrix1112,"T ref",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
	new FXTextField(matrix1112,10,&double_Tref,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
	new FXLabel(matrix1112,"grad K",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);

	new FXFrame(matrix1112,LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
	new FXLabel(matrix1112,"Re number",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
	new FXTextField(matrix1112,10,&double_Reref,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
	new FXFrame(matrix1112,LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);

	new FXFrame(matrix1112,LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
	new FXLabel(matrix1112,"L ref",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
	new FXTextField(matrix1112,10,&double_Lref,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
	new FXLabel(matrix1112,"m",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);

	new FXFrame(matrix1112,LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
	new FXLabel(matrix1112,"S ref",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
	new FXTextField(matrix1112,10,&double_Sref,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
	new FXLabel(matrix1112,"m*m",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);

	new FXFrame(matrix1112,LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
	new FXLabel(matrix1112,"Angle of attack",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
	new FXTextField(matrix1112,10,&double_ALref,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
	new FXLabel(matrix1112,"grad",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);

	group112=new FXHorizontalFrame(group11,LAYOUT_TOP|LAYOUT_FILL_X, 0,0,0,0, 0,0,0,0);
  button=new FXButton(group112,"Compute",NULL,this,ID_COMPUTE,
                      FRAME_RAISED|FRAME_THICK|LAYOUT_CENTER_X|LAYOUT_CENTER_Y,
                      0,0,110,25);
    button->setTipText(tr("Recalculation"));
buttonOut=new FXButton(group112,"Output to file: RefValues.out",NULL,this,ID_OUTPUTTOFILE,
                      FRAME_RAISED|FRAME_THICK|LAYOUT_CENTER_X|LAYOUT_CENTER_Y,
                      0,0,150,25);

  group113=new FXVerticalFrame(group11, FRAME_SUNKEN|LAYOUT_FILL_X|LAYOUT_FILL_Y, 0,0,0,0, 0,0,0,0);
  group1131=new FXVerticalFrame(group113, LAYOUT_FILL_X|LAYOUT_FILL_Y, 0,0,0,0, 0,0,0,0);
    new FXLabel(group1131,"Data for BL estimation",NULL,JUSTIFY_CENTER_X|LAYOUT_FILL_X);
    new FXHorizontalSeparator(group1131,SEPARATOR_GROOVE|LAYOUT_FILL_X);
  matrix1132=new FXMatrix(group113,4,MATRIX_BY_COLUMNS|LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y);
	new FXLabel(matrix1132,"X/L ref=",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
	new FXTextField(matrix1132,10,&double_Xref,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
	new FXLabel(matrix1132,"Yplus=",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
	new FXTextField(matrix1132,10,&double_Yplus,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);

	new FXLabel(matrix1132,"k =",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
	new FXTextField(matrix1132,10,&double_K,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
	new FXLabel(matrix1132,"y1 =",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
	new FXTextField(matrix1132,10,&double_Y1,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);

	new FXLabel(matrix1132,"n =",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
	new FXTextField(matrix1132,10,&int_N,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
	new FXLabel(matrix1132,"y =",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
	new FXTextField(matrix1132,10,&double_Y,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);

//----------------------------------------------------------------------------------------------
  group12=new FXVerticalFrame(group1, LAYOUT_FILL_X|LAYOUT_FILL_Y, 0,0,0,0, 0,0,0,0);
  group121=new FXVerticalFrame(group12,FRAME_SUNKEN|LAYOUT_FILL_X|LAYOUT_FILL_Y, 0,0,0,0, 0,0,0,0);
    new FXLabel(group121,"OUTPUT VALUES",NULL,JUSTIFY_CENTER_X|LAYOUT_FILL_X);
    new FXHorizontalSeparator(group121,SEPARATOR_GROOVE|LAYOUT_FILL_X);
  matrix1212=new FXMatrix(group121,3,MATRIX_BY_COLUMNS|LAYOUT_SIDE_TOP|LAYOUT_FILL_X|LAYOUT_FILL_Y);

	new FXLabel(matrix1212,"U=",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
	new FXTextField(matrix1212,10,&double_U8,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
	new FXLabel(matrix1212,"m/sec",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);

	new FXLabel(matrix1212,"Ux,(Uy or Uz)=",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
	new FXTextField(matrix1212,10,&double_Ux,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
	new FXTextField(matrix1212,10,&double_Uyz,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);

	new FXLabel(matrix1212,"Mu=",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
	new FXTextField(matrix1212,10,&double_Mu,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
	new FXLabel(matrix1212,"Pa*sec",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);

	new FXLabel(matrix1212,"Nu=",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
	new FXTextField(matrix1212,10,&double_Nu,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
	new FXLabel(matrix1212,"(m*m)/sec",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);

	new FXLabel(matrix1212,"Rho=",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
	new FXTextField(matrix1212,10,&double_Rho,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
	new FXLabel(matrix1212,"kg/(m*m*m)",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);

	new FXLabel(matrix1212,"P=",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
	new FXTextField(matrix1212,10,&double_P,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
	new FXLabel(matrix1212,"Pa(N/(m*m))",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);

	new FXLabel(matrix1212,"0.5*Rho*U*U=",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
	new FXTextField(matrix1212,10,&double_RUU,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
	new FXLabel(matrix1212,"kg/(m*sec*sec)",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);

	new FXLabel(matrix1212,"S*0.5*Rho*U*U=",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
	new FXTextField(matrix1212,10,&double_SRUU,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
	new FXLabel(matrix1212,"kg*m/(sec*sec))",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);

	new FXFrame(matrix1212,LAYOUT_FILL_COLUMN|LAYOUT_FILL_ROW);
	new FXLabel(matrix1212,"X",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
	new FXLabel(matrix1212,"Y or Z",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);

	new FXLabel(matrix1212,"Lift direction",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
	new FXTextField(matrix1212,10,&double_XLift,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
	new FXTextField(matrix1212,10,&double_YZLift,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);

	new FXLabel(matrix1212,"Drag direction",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
	new FXTextField(matrix1212,10,&double_XDrag,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
	new FXTextField(matrix1212,10,&double_YZDrag,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);

  group122=new FXVerticalFrame(group12, FRAME_SUNKEN|LAYOUT_FILL_X|LAYOUT_FILL_Y, 0,0,0,0, 0,0,0,0);
    new FXLabel(group122,"BL plate (X/Lref) estimation",NULL,JUSTIFY_CENTER_X|LAYOUT_FILL_X);
    new FXHorizontalSeparator(group122,SEPARATOR_GROOVE|LAYOUT_FILL_X);
  group1221=new FXHorizontalFrame(group122,LAYOUT_FILL_X|LAYOUT_FILL_Y);
	new FXLabel(group1221,"Dstar=",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
	new FXTextField(group1221,10,&double_Dstar,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
	new FXLabel(group1221,"D =",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
	new FXTextField(group1221,10,&double_Delta,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);
  group1222=new FXHorizontalFrame(group122,LAYOUT_FILL_X|LAYOUT_FILL_Y);
	new FXLabel(group1222,"Cf turb plate (x/Lref) =",NULL,LAYOUT_CENTER_Y|LAYOUT_CENTER_X|JUSTIFY_RIGHT|LAYOUT_FILL_ROW);
	new FXTextField(group1222,10,&double_Cfturb,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK|LAYOUT_FILL_ROW);

  group2=new FXVerticalFrame(content,FRAME_SUNKEN|LAYOUT_FILL_X|LAYOUT_SIDE_TOP, 0,0,0,0, 0,0,0,0);
  group21=new FXVerticalFrame(group2,LAYOUT_FILL_X|LAYOUT_TOP, 0,0,0,0, 0,0,0,0);
    new FXLabel(group21,"Data for BL node distribution",NULL,JUSTIFY_CENTER_X|LAYOUT_FILL_X|LAYOUT_TOP, 0,0,0,0, 0,0,0,0);
    new FXHorizontalSeparator(group21,SEPARATOR_GROOVE|LAYOUT_FILL_X);
  group22=new FXHorizontalFrame(group2,  LAYOUT_FILL_X|LAYOUT_FILL_Y );
  group221=new FXVerticalFrame(group22,  LAYOUT_FILL_Y);
    new FXLabel(group221,"The size of the initial cell",NULL,JUSTIFY_CENTER_X|LAYOUT_FILL_X|LAYOUT_SIDE_TOP );
	new FXTextField(group221,10,&double_SCell,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK);
    new FXHorizontalSeparator(group221,SEPARATOR_GROOVE|LAYOUT_FILL_X);
    new FXLabel(group221,"Max refinement",NULL,JUSTIFY_CENTER_X|LAYOUT_FILL_X|LAYOUT_SIDE_TOP);
	new FXTextField(group221,10,&int_MRefin,FXDataTarget::ID_VALUE,TEXTFIELD_REAL|LAYOUT_CENTER_Y|LAYOUT_CENTER_X|FRAME_SUNKEN|FRAME_THICK);
  group222=new FXVerticalFrame(group22,FRAME_THICK|LAYOUT_TOP|LAYOUT_FILL_X, 0,0,0,0, 0,0,0,0);
  // Table
  table=new FXTable(group222,this,ID_TABLE,LAYOUT_FILL_X|LAYOUT_SIDE_TOP,0,0,0,0, 2,2,2,2);
  table->setDefColumnWidth(70);
  table->setRowHeaderWidth(70);
  table->setDefRowHeight(20);
  table->setColumnHeaderHeight(20);
//  table->setRowHeight(1,15);
  table->setVisibleRows(8);
  table->setVisibleColumns(4);
//  table->setRowHeaderMode(0);
  table->setTableSize(8,4);
  table->setBackColor(FXRGB(255,255,255));
  table->setCellColor(0,0,FXRGB(255,255,255));
  table->setCellColor(0,1,FXRGB(255,240,240));
  table->setCellColor(1,0,FXRGB(240,255,240));
  table->setCellColor(1,1,FXRGB(240,240,255));

  table->setColumnText(0,"Y plus =");
  table->setRowText(1,"Refinement");
  table->setItemText(0,0,"Del Y1 =");
  table->setItemText(1,0,"Size of Cell");

  this->FillTable();

}
RefValues::~RefValues()
{
}
void RefValues::create()
{
	FXMainWindow::create();
	show(PLACEMENT_SCREEN);
}
void RefValues::ComputeRef()
{
    if (T_opt == 1)
        T_0 = T_Ref * (1. + 0.2 * M_Ref * M_Ref);
    else
        T_Ref = T_0 / (1. + 0.2 * M_Ref * M_Ref);


//    Nu_Water = 1.01      ' T=293K
//    Nu_Glycerine = 680#  ' T=293K
//    Rho_Water = 997.3    ' T=293K
//    Rho_Glycerine = 997.3    '???? T=293K
    A_Ref = sqrt(287.053*1.4*T_Ref);
//    A_Ref = 20.1 * sqrt(T_Ref);
    U_Ref = A_Ref * M_Ref;
    Nu_Ref = U_Ref * L_Ref / Re_Ref;
    Mu_Ref = 1.458E-6*pow(T_Ref,1.5)/(T_Ref+110.4);
//    Mu_Ref = 0.00000151204 * T_Ref * sqrt(T_Ref) / (T_Ref + 120.);
    Rho_Ref = Mu_Ref / Nu_Ref;
    P_Ref = Rho_Ref * T_Ref * 287.053;


    RUU = 0.5 * Rho_Ref * U_Ref * U_Ref;
    SRUU = S_Ref * RUU;

    AL_Rad = AL_Ref * 3.14159265 / 180.;

    XLift = -sin(AL_Rad);
    YZLift = cos(AL_Rad);

    XDrag = cos(AL_Rad);
    YZDrag = sin(AL_Rad);

    Ux = U_Ref * cos(AL_Rad);
    Uyz = U_Ref * sin(AL_Rad);

    X_Ref = L_Ref * X_Ref;
//    Cf_turb = 0.0576 * (Re_Ref ^ -0.2) * (X_Ref ^ -0.2)
	double pw=pow((U_Ref * X_Ref / Nu_Ref), -0.2);
    Cfturb = 0.0576 * pw;

    Y1 = Yplus / sqrt(Cfturb * 0.5) / Re_Ref * L_Ref;

    if (K==1)
		Y = Y1 * N ;
	else
		Y = Y1 * (pow(K , N) - 1) / (K - 1);

    Delta = 0.37 * X_Ref * pw;
    Dstar = Delta / 8.;


}
void RefValues::FillTable()
{
  int i;
  for (i=1; i<4; i++)
  {
    table->setColumnText(i,FXString::value(Yplus));
	table->setItemText(0,i,FXString::value(Y1,2,1));
	table->setItemText(1,i,"k = "+FXString::value(1.2 + (i - 1) * 0.05));
  }

    N_Rows = 6;
    for (i = 1; i < N_Rows+1; i++)
	{
        Refin = MRefin - N_Rows + i;
        SC = SCell / pow(2 , Refin);
		table->setRowText(1+i,FXString::value(Refin));
		table->setItemText(1+i,0,FXString::value(SC,2,1));
        NCellsBL = log(SC * 0.2 / Y1 + 1) / log(1.2);
		table->setItemText(1+i,1,FXString::value(NCellsBL,1,0));
        NCellsBL = log(SC * 0.25 / Y1 + 1) / log(1.25);
		table->setItemText(1+i,2,FXString::value(NCellsBL,1,0));
        NCellsBL = log(SC * 0.3 / Y1 + 1) / log(1.3);
		table->setItemText(1+i,3,FXString::value(NCellsBL,1,0));
    }
}
// Compute
long RefValues::onCmdCompute(FXObject*,FXSelector,void*)
{
  this->ComputeRef();
  this->FillTable();
  return 1;
}


// Output to file
long RefValues::onCmdOutputToFile(FXObject*,FXSelector,void*)
{

  const FXchar patterns[]="All Files (*)\nRef.Values, output Files (*.out)";
  FXFileDialog savedialog(this,"Save file");
  savedialog.setPatternList(patterns);
  savedialog.setDirectory(".");
  if(savedialog.execute())
  {
    std::ofstream outfile((savedialog.getFilename()).text(),std::ios::out);
    {
	  std::cout.precision(4);
	  std::cout.width(7);
      outfile << "--------Specified values --------\n";
      outfile << " Mach = " << M_Ref;
      outfile << "\n Re   = " << Re_Ref;
      outfile << "\n Alfa = " << AL_Ref << " grad\n";
      outfile << "---------------------------------";
      outfile << "\n Tref = " << T_Ref << " grad K";
      outfile << "\n Lref = " << L_Ref << " m";
      outfile << "\n Sref = " << S_Ref << " m*m";
      outfile << "\n---------------------------------";
      outfile << "\n--------Calculated values -------";
      outfile << "\n Uref = " << U_Ref << " m/sec";
      outfile << "\n Ux   = " << Ux << "       Uy   = " << Uyz;
      outfile << "\n Mu   = " << Mu_Ref << " Pa*sec";
      outfile << "\n Nu   = " << Nu_Ref << " (m*m)/sec";
      outfile << "\n Rho  = " << Rho_Ref << " kg/(m*m*m)";
      outfile << "\n P    = " << P_Ref << " Pa = N/(m*m)";
      outfile << "\n--------------------------------------------";
      outfile << "\n   0.5*Rho*U*U  = " << RUU << " kg/(m*sec*sec)";
      outfile << "\n S*0.5*Rho*U*U  = " << SRUU << " kg*m/(sec*sec)";
      outfile << "\n--------------------------------------------";
      outfile << "\n Lift direction  X=" << XLift << "    Y=" << YZLift;
      outfile << "\n Drag direction  X=" << XDrag << "    Y=" << YZDrag;
      outfile << "\n----------------------------------------------------------";
      outfile << "\n   Data for BL node distribution   Yplus=" << Yplus << "    Y1=" << Y1;
      outfile << "\n----------------------------------------------------------";
      outfile << "\n   Refinement   SizeOfCell    k1= 1.20  k1= 1.25  k1=1.3";
      outfile << "\n----------------------------------------------------------";
//	  FXString aaa=table->getItemText(3, 1);
      for (int i = 1; i< N_Rows+1; i++)
      {
        Refin = MRefin - N_Rows + i;
	    outfile << "\n";
        if (Refin >9)
          outfile << "       ";
        else
	      outfile << "        ";

	    outfile << (table->getRowText(1+i)).text();
        outfile << "        " << (table->getItemText(1 + i, 0)).text() << "        " << (table->getItemText(1 + i, 1)).text() << "      " << (table->getItemText(1 + i, 2)).text() << "      " << (table->getItemText(1 + i, 3)).text(); // << "      " << (table->getItemText(1 + i, 4)).text();
      }
      outfile << "\n----------------------------------------------------------";
      outfile.close();
	}
  }
  return 1;
}

int main(int argc,char ** argv)
{

   FXApp application("RefValues","FOX RefValues");

   application.init(argc,argv);

   new RefValues(&application);

   application.create();

   return application.run();

}
