#include "xincs.h"
#include "fxver.h"
#include "fxdefs.h"
#include "FXHash.h"
#include "FXStream.h"
#include "FXTextCodec.h"
#include "FX885914Codec.h"

namespace FX {

FXIMPLEMENT(FX885914Codec,FXTextCodec,NULL,0)


//// Created by codec tool on 03/25/2005 from: 8859-14.TXT ////
static const unsigned short forward_data[256]={
   0,    1,    2,    3,    4,    5,    6,    7,    8,    9,    10,   11,   12,   13,   14,   15,
   16,   17,   18,   19,   20,   21,   22,   23,   24,   25,   26,   27,   28,   29,   30,   31,
   32,   33,   34,   35,   36,   37,   38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
   48,   49,   50,   51,   52,   53,   54,   55,   56,   57,   58,   59,   60,   61,   62,   63,
   64,   65,   66,   67,   68,   69,   70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
   80,   81,   82,   83,   84,   85,   86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
   96,   97,   98,   99,   100,  101,  102,  103,  104,  105,  106,  107,  108,  109,  110,  111,
   112,  113,  114,  115,  116,  117,  118,  119,  120,  121,  122,  123,  124,  125,  126,  127,
   128,  129,  130,  131,  132,  133,  134,  135,  136,  137,  138,  139,  140,  141,  142,  143,
   144,  145,  146,  147,  148,  149,  150,  151,  152,  153,  154,  155,  156,  157,  158,  159,
   160,  7682, 7683, 163,  266,  267,  7690, 167,  7808, 169,  7810, 7691, 7922, 173,  174,  376,
   7710, 7711, 288,  289,  7744, 7745, 182,  7766, 7809, 7767, 7811, 7776, 7923, 7812, 7813, 7777,
   192,  193,  194,  195,  196,  197,  198,  199,  200,  201,  202,  203,  204,  205,  206,  207,
   372,  209,  210,  211,  212,  213,  214,  7786, 216,  217,  218,  219,  220,  221,  374,  223,
   224,  225,  226,  227,  228,  229,  230,  231,  232,  233,  234,  235,  236,  237,  238,  239,
   373,  241,  242,  243,  244,  245,  246,  7787, 248,  249,  250,  251,  252,  253,  375,  255,
  };


static const unsigned char reverse_plane[17]={
  0, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  };

static const unsigned char reverse_pages[72]={
  0,  24, 24, 24, 24, 24, 24, 56, 24, 24, 24, 24, 24, 24, 24, 24,
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
  24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24, 24,
  24, 24, 24, 24, 24, 24, 24, 24,
  };

static const unsigned short reverse_block[120]={
  0,   16,  32,  48,  64,  80,  96,  112, 128, 144, 160, 175, 191, 207, 223, 239,
  255, 267, 283, 267, 267, 267, 267, 295, 267, 267, 267, 267, 267, 267, 267, 267,
  267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267,
  267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267,
  267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267, 267,
  267, 267, 267, 267, 267, 267, 267, 267, 309, 321, 267, 267, 337, 347, 363, 267,
  379, 267, 267, 267, 267, 267, 267, 393, 267, 267, 267, 267, 267, 267, 267, 267,
  267, 267, 267, 267, 267, 267, 267, 267,
  };

static const unsigned char reverse_data[409]={
   0,    1,    2,    3,    4,    5,    6,    7,    8,    9,    10,   11,   12,   13,   14,   15,
   16,   17,   18,   19,   20,   21,   22,   23,   24,   25,   26,   27,   28,   29,   30,   31,
   32,   33,   34,   35,   36,   37,   38,   39,   40,   41,   42,   43,   44,   45,   46,   47,
   48,   49,   50,   51,   52,   53,   54,   55,   56,   57,   58,   59,   60,   61,   62,   63,
   64,   65,   66,   67,   68,   69,   70,   71,   72,   73,   74,   75,   76,   77,   78,   79,
   80,   81,   82,   83,   84,   85,   86,   87,   88,   89,   90,   91,   92,   93,   94,   95,
   96,   97,   98,   99,   100,  101,  102,  103,  104,  105,  106,  107,  108,  109,  110,  111,
   112,  113,  114,  115,  116,  117,  118,  119,  120,  121,  122,  123,  124,  125,  126,  127,
   128,  129,  130,  131,  132,  133,  134,  135,  136,  137,  138,  139,  140,  141,  142,  143,
   144,  145,  146,  147,  148,  149,  150,  151,  152,  153,  154,  155,  156,  157,  158,  159,
   160,  26,   26,   163,  26,   26,   26,   167,  26,   169,  26,   26,   26,   173,  174,  26,
   26,   26,   26,   26,   26,   182,  26,   26,   26,   26,   26,   26,   26,   26,   26,   192,
   193,  194,  195,  196,  197,  198,  199,  200,  201,  202,  203,  204,  205,  206,  207,  26,
   209,  210,  211,  212,  213,  214,  26,   216,  217,  218,  219,  220,  221,  26,   223,  224,
   225,  226,  227,  228,  229,  230,  231,  232,  233,  234,  235,  236,  237,  238,  239,  26,
   241,  242,  243,  244,  245,  246,  26,   248,  249,  250,  251,  252,  253,  26,   255,  26,
   26,   26,   26,   26,   26,   26,   26,   26,   26,   164,  165,  26,   26,   26,   26,   26,
   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   178,  179,  26,   26,   26,
   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   208,  240,  222,  254,  175,
   26,   26,   26,   26,   26,   26,   26,   161,  162,  26,   26,   26,   26,   26,   26,   166,
   171,  26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   176,
   177,  180,  181,  26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   26,
   26,   183,  185,  26,   26,   26,   26,   26,   26,   26,   26,   187,  191,  26,   26,   26,
   26,   26,   26,   26,   26,   215,  247,  26,   26,   26,   26,   168,  184,  170,  186,  189,
   190,  26,   26,   26,   26,   26,   26,   26,   26,   26,   26,   172,  188,  26,   26,   26,
   26,   26,   26,   26,   26,   26,   26,   26,   26,
  };


FXint FX885914Codec::mb2wc(FXwchar& wc,const FXchar* src,FXint nsrc) const {
  if(nsrc<1) return -1;
  wc=forward_data[(FXuchar)src[0]];
  return 1;
  }


FXint FX885914Codec::wc2mb(FXchar* dst,FXint ndst,FXwchar wc) const {
  if(ndst<1) return -1;
  dst[0]=reverse_data[reverse_block[reverse_pages[reverse_plane[wc>>16]+((wc>>10)&63)]+((wc>>4)&63)]+(wc&15)];
  return 1;
  }

FXint FX885914Codec::mibEnum() const {
  return 110;
  }


const FXchar* FX885914Codec::name() const {
  return "ISO-8859-14";
  }


const FXchar* FX885914Codec::mimeName() const {
  return "ISO-8859-14";
  }


const FXchar* const* FX885914Codec::aliases() const {
  static const FXchar *const list[]={"iso8859-14","ISO-8859-14","ISO_8859-14",NULL};
  return list;
  }

}

